﻿Imports System.Net.Sockets

Public Class frmU3800_Ext_SG_VCorrection
    Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

    '************************************
    '* Setting acquisition of a Textbox *
    '************************************
    Private Sub GetSetting()
        str_U38_TcpipAddress = Txt_U38_IP_Address.Text
        Call WriteIniFile_U38_TCPIP_Adrs(Txt_U38_IP_Address.Text)

        str_SG_TcpipAddress = Txt_SG_IP_Address.Text
        Call WriteIniFile_SG_TCPIP_Adrs(Txt_SG_IP_Address.Text)

        SG_OutputLevel = CSng(Txt_SG_Out_Level.Text)
        Call WriteIniFile_SG_OUT_LVL(Txt_SG_Out_Level.Text)

        If Rad_VCorr_Type1.Checked = True Then
            Call WriteIniFile_U38_VCorr_Type(Rad_VCorr_Type1.Text)
        Else
            Call WriteIniFile_U38_VCorr_Type(Rad_VCorr_Type2.Text)
        End If
    End Sub

    '***********************************************************
    '* U3800 External SG Vector Correction Start               *
    '*                                                         *
    '* Etherbet I/F                                            *
    '*   3Com 3C920 Integrated Fast Ethernet Controller        *
    '*                                                         *
    '* E8257D (Agilent) PSG Analog Signal Generator            *
    '*   GPIB (SCIPI) Command                                  *
    '*   SG_OUTPUT__CMD = "OUTP "                              *
    '*   SG_OUT_ON__CMD = "ON"                                 *
    '*   SG_OUT_OFF_CMD = "OFF"                                *
    '*   SG_OUT_LVL_CMD = "SOUR:POW "                          *
    '*   SG_OUT_LVL_UNT = "DBM"                                *
    '*   SG_SET_FRQ_CMD = "SOUR:FREQ "                         *
    '*   SG_SET_FRQ_UNT = "HZ"                                 *
    '*                                                         *
    '***********************************************************
    Private Sub Btn_VCorrStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_VCorrStart.Click
        Dim err As Long
        Dim i As Long
        Dim buf As String
        Dim VCorr_TtlCnt As Long
        Dim strVCorr_TtlCnt As String
        Dim CentFreq As Double
        Dim OfstFreq As Double
        Dim strFreq As String

        Lbl_SG_Start_Freq.Text = ""
        Lbl_SG_Step_Freq.Text = ""
        Lbl_SG_End_Freq.Text = ""
        Lbl_SG_Current_Freq.Text = ""
        Lbl_Count.Text = "/"

        Call GetSetting()        ' U3800 & SG Setting acquisition of a Textbox.

        '*** TCP/IP ****
        buf = Space(32)
        TcpipConnect = True
        If OpenTcpIpClient(U38_client, str_U38_TcpipAddress, U38_PortNo) < 0 Then
            err = MsgBox("Can't open the TCP/IP address(" & str_U38_TcpipAddress & ").", vbOKOnly)
            TcpipConnect = False
        Else
            err = GetTcpIpClient(U38_client, buf)
            err = PutTcpIpClient(U38_client, "REN")
        End If
        If OpenTcpIpClient(SG_client, str_SG_TcpipAddress, SG_PortNo) < 0 Then
            err = MsgBox("Can't open the TCP/IP address(" & str_SG_TcpipAddress & ").", vbOKOnly)
            TcpipConnect = False
        End If

        If TcpipConnect = False Then Exit Sub

        err = PutTcpIpClient(U38_client, "RFE")
        err = PutTcpIpClient(U38_client, "VCSIGSRC EXT")                'SigSrc EXT

        err = QeryTcpIpClient(U38_client, "CF?", buf)
        If err < 0 Then
            err = MsgBox("CF? query command error.", vbOKOnly)
            GoTo SocketClose
        End If

        CentFreq = CDbl(Trim(buf))
        strFreq = CStr(CentFreq)
        err = PutTcpIpClient(SG_client, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
        Lbl_SG_Start_Freq.Text = Trim(buf) : Lbl_SG_Start_Freq.Refresh()

        'Set SG output on
        err = PutTcpIpClient(SG_client, SG_OUT_ON__CMD)

        'Set SG output level
        err = PutTcpIpClient(SG_client, SG_OUT_LVL_CMD & CStr(SG_OutputLevel) & SG_OUT_LVL_UNT)
        Call Sleep(500)

        VCorrAbort = False

        If Me.Rad_VCorr_Type1.Checked = True Then                       '*** Specific Span ***
            'Xmath 1.Power Ratio Phase Diff Execute ON/OFF
            err = QeryTcpIpClient(U38_client, "XPRPDON?", buf) : i = CLng(buf)
            'Xmath 2.Differential Execute ON/OFF
            err = QeryTcpIpClient(U38_client, "XDIFFON?", buf) : i = i + CLng(buf)
            'Xmath 4.Power Math Execute ON/OFF
            err = QeryTcpIpClient(U38_client, "XMATHON?", buf) : i = i + CLng(buf)
            If i = 0 Then
                err = MsgBox("Xmath Function OFF.", vbOKOnly)
                GoTo SocketClose
            End If

            err = PutTcpIpClient(U38_client, "VCFSEXTINIT")             '     Initialize Specific Span external SG vector correction.
            err = QeryTcpIpClient(U38_client, "VCFSEXTSTPSZ?", buf)     '     Get Specific Span external SG vector correction total count.
            If err < 0 Then
                err = MsgBox("VCFSEXTSTPSZ? query command error.", vbOKOnly)
                Exit Sub
            End If
            VCorr_TtlCnt = CLng(buf)                                    '     External SG vector correction total count.
            strVCorr_TtlCnt = CStr(VCorr_TtlCnt)

            err = QeryTcpIpClient(U38_client, "VCFA?", buf)             '     Start Freq.
            CentFreq = CDbl(Trim(buf))
            strFreq = CStr(CentFreq)
            err = PutTcpIpClient(SG_client, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
            Call Sleep(1000)
            Lbl_SG_Start_Freq.Text = Trim(buf) : Lbl_SG_Start_Freq.Refresh()
            err = QeryTcpIpClient(U38_client, "VCFB?", buf)             '     Stop  Freq.
            Lbl_SG_End_Freq.Text = Trim(buf) : Lbl_SG_End_Freq.Refresh()
            err = QeryTcpIpClient(U38_client, "VCFSTEP?", buf)          '     Step  Freq.
            Lbl_SG_Step_Freq.Text = Trim(buf) : Lbl_SG_Step_Freq.Refresh()

            Lbl_Count.Text = "0/" & strVCorr_TtlCnt
            Lbl_Count.Refresh()

            For i = 1 To VCorr_TtlCnt
                If VCorrAbort = True Then Exit For
                err = PutTcpIpClient(U38_client, "VCFSEXTIDX " & CStr(i))
                err = QeryTcpIpClient(U38_client, "CF?", buf)
                CentFreq = CDbl(Trim(buf))
                strFreq = CStr(CentFreq)
                Lbl_SG_Current_Freq.Text = strFreq
                Lbl_SG_Current_Freq.Refresh()
                err = PutTcpIpClient(SG_client, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
                Call Sleep(1000)
                err = PutTcpIpClient(U38_client, "VCFSEXTEXE")
                Lbl_Count.Text = CStr(i) & " / " & strVCorr_TtlCnt
                Lbl_Count.Refresh()
                Application.DoEvents()
            Next i

            If VCorrAbort = False Then
                err = PutTcpIpClient(U38_client, "VCFSEXTFINISH")       '     End Specific Span vector correction.
            Else
                err = PutTcpIpClient(U38_client, "VCFSEXTABORT")        '     Abort Specific Span vector correction.
                err = PutTcpIpClient(U38_client, "VCSIGSRC INT")        '     SigSrc INT
            End If
        Else                                                            '*** InBand ***
            err = PutTcpIpClient(U38_client, "VCINBEXTINIT")            '     Initialize InBand external SG vector correction.
            err = QeryTcpIpClient(U38_client, "VCINBEXTSTPSZ?", buf)    '     Get InBand external SG vector correction total count.
            If err < 0 Then
                err = MsgBox("VCINBEXTSTPSZ? query command error.", vbOKOnly)
                Exit Sub
            End If
            VCorr_TtlCnt = CLng(buf)                                    '     External SG vector correction total count.
            strVCorr_TtlCnt = CStr(VCorr_TtlCnt)

            Lbl_Count.Text = "0/" & strVCorr_TtlCnt
            Lbl_Count.Refresh()

            For i = 1 To VCorr_TtlCnt
                If VCorrAbort = True Then Exit For
                err = PutTcpIpClient(U38_client, "VCINBEXTIDX " & CStr(i))
                err = QeryTcpIpClient(U38_client, "VCINBEXTFO?", buf)
                OfstFreq = CDbl(Trim(buf))
                err = QeryTcpIpClient(U38_client, "CF?", buf)
                CentFreq = CDbl(buf)
                strFreq = CStr(CentFreq + OfstFreq)
                Lbl_SG_Current_Freq.Text = strFreq
                Lbl_SG_Current_Freq.Refresh()
                err = PutTcpIpClient(SG_client, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
                Call Sleep(1000)
                err = PutTcpIpClient(U38_client, "VCINBEXTEXE")
                Lbl_Count.Text = CStr(i) & " / " & strVCorr_TtlCnt
                Lbl_Count.Refresh()
                Application.DoEvents()
            Next i

            If VCorrAbort = False Then
                err = PutTcpIpClient(U38_client, "VCINBEXTFINISH")      '     End InBand vector correction.
            Else
                err = PutTcpIpClient(U38_client, "VCINBEXTABORT")       '     Abort InBand vector correction.
                err = PutTcpIpClient(U38_client, "VCSIGSRC INT")        '     SigSrc INT
            End If
        End If

SocketClose:
        Call CloseTcpIpClient(U38_client)
        Call CloseTcpIpClient(SG_client)

    End Sub

    '*********************************************
    '* U3800 External SG Vector Correction Abort *
    '*********************************************
    Private Sub Btn_VCorrAbort_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_VCorrAbort.Click
        VCorrAbort = True
    End Sub


    Private Sub frmU3800_Ext_SG_VCorrection_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        U38_client = New TcpClient
        SG_client = New TcpClient

        VCorrAbort = False

        str_U38_TcpipAddress = Trim(ReadIniFile_U38_TCPIP_Adrs())
        Txt_U38_IP_Address.Text = str_U38_TcpipAddress
        Call WriteIniFile_U38_TCPIP_Adrs(Txt_U38_IP_Address.Text)

        str_SG_TcpipAddress = Trim(ReadIniFile_SG_TCPIP_Adrs())
        Txt_SG_IP_Address.Text = str_SG_TcpipAddress
        Call WriteIniFile_SG_TCPIP_Adrs(Txt_SG_IP_Address.Text)

        U38_PortNo = CLng(ReadIniFile_U38_PortNo())
        Call WriteIniFile_U38_PortNo(CStr(U38_PortNo))

        SG_PortNo = CLng(ReadIniFile_SG_PortNo())
        Call WriteIniFile_SG_PortNo(CStr(SG_PortNo))

        SG_OutputLevel = CSng(Trim(ReadIniFile_SG_OUT_LVL()))
        Txt_SG_Out_Level.Text = CStr(SG_OutputLevel)
        Call WriteIniFile_SG_OUT_LVL(Txt_SG_Out_Level.Text)

        If "Specific Span" = Trim(ReadIniFile_U38_VCorr_Type()) Then
            Rad_VCorr_Type1.Checked = True
            Rad_VCorr_Type2.Checked = False
            Call WriteIniFile_U38_VCorr_Type(Rad_VCorr_Type1.Text)
        Else
            Rad_VCorr_Type1.Checked = False
            Rad_VCorr_Type2.Checked = True
            Call WriteIniFile_U38_VCorr_Type(Rad_VCorr_Type2.Text)
        End If

        SG_OUTPUT__CMD = Trim(ReadIniFile_SG_OUT_STS_Cmd())
        Call WriteIniFile_SG_OUT_STS_Cmd(SG_OUTPUT__CMD)

        SG_OUT_ON__CMD = Trim(ReadIniFile_SG_OUT_ON_Para())
        Call WriteIniFile_SG_OUT_ON_Para(SG_OUT_ON__CMD)
        SG_OUT_ON__CMD = SG_OUTPUT__CMD & " " & SG_OUT_ON__CMD

        SG_OUT_OFF_CMD = Trim(ReadIniFile_SG_OUT_OFF_Para())
        Call WriteIniFile_SG_OUT_OFF_Para(SG_OUT_OFF_CMD)
        SG_OUT_OFF_CMD = SG_OUTPUT__CMD & " " & SG_OUT_OFF_CMD

        SG_OUT_LVL_CMD = Trim(ReadIniFile_SG_OUT_LVL_Cmd())
        Call WriteIniFile_SG_OUT_LVL_Cmd(SG_OUT_LVL_CMD)
        SG_OUT_LVL_CMD = SG_OUT_LVL_CMD & " "

        SG_OUT_LVL_UNT = Trim(ReadIniFile_SG_OUT_LVL_Unit())
        Call WriteIniFile_SG_OUT_LVL_Unit(SG_OUT_LVL_UNT)

        SG_SET_FRQ_CMD = Trim(ReadIniFile_SG_Freq_Cmd())
        Call WriteIniFile_SG_Freq_Cmd(SG_SET_FRQ_CMD)
        SG_SET_FRQ_CMD = SG_SET_FRQ_CMD & " "

        SG_SET_FRQ_UNT = Trim(ReadIniFile_SG_Freq_Unit())
        Call WriteIniFile_SG_Freq_Unit(SG_SET_FRQ_UNT)

    End Sub

End Class
